/**
 * AIMS Profile System JavaScript
 * Handles profile picture and cover photo uploads, and friend requests
 * File: profile/js/profile.js
 * Student: Musumba Jonathan (21/BCS/010/UMC)
 */

function uploadProfilePicture(input) {
    if (input.files && input.files[0]) {
        const file = input.files[0];
        
        // Validate file type
        if (!file.type.match('image.*')) {
            showToast('Please select an image file', 'error');
            return;
        }
        
        // Validate file size (5MB max)
        if (file.size > 5 * 1024 * 1024) {
            showToast('File too large. Maximum 5MB allowed', 'error');
            return;
        }
        
        const formData = new FormData();
        formData.append('profile_picture', file);
        
        showLoading();
        
        fetch(APP_URL + '/profile/ajax/upload-profile-picture.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                showToast('Profile picture updated successfully', 'success');
                setTimeout(() => location.reload(), 1000);
            } else {
                showToast(data.message || 'Failed to upload profile picture', 'error');
            }
        })
        .catch(error => {
            hideLoading();
            showToast('An error occurred while uploading', 'error');
            console.error('Error:', error);
        });
    }
}

function uploadCoverPhoto(input) {
    if (input.files && input.files[0]) {
        const file = input.files[0];
        
        // Validate file type
        if (!file.type.match('image.*')) {
            showToast('Please select an image file', 'error');
            return;
        }
        
        // Validate file size (5MB max)
        if (file.size > 5 * 1024 * 1024) {
            showToast('File too large. Maximum 5MB allowed', 'error');
            return;
        }
        
        const formData = new FormData();
        formData.append('cover_photo', file);
        
        showLoading();
        
        fetch(APP_URL + '/profile/ajax/upload-cover-photo.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                showToast('Cover photo updated successfully', 'success');
                setTimeout(() => location.reload(), 1000);
            } else {
                showToast(data.message || 'Failed to upload cover photo', 'error');
            }
        })
        .catch(error => {
            hideLoading();
            showToast('An error occurred while uploading', 'error');
            console.error('Error:', error);
        });
    }
}

function sendFriendRequest(userId) {
    if (!confirm('Send friend request to this user?')) return;
    
    showLoading();
    
    fetch(APP_URL + '/friends/ajax/send-request.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ user_id: userId })
    })
    .then(response => response.json())
    .then(data => {
        hideLoading();
        showToast(data.message, data.success ? 'success' : 'error');
        if (data.success) {
            setTimeout(() => location.reload(), 1000);
        }
    })
    .catch(error => {
        hideLoading();
        showToast('Failed to send friend request', 'error');
        console.error('Error:', error);
    });
}