<?php
require_once __DIR__ . '/includes/base.php';
$breadcrumbs = [['title' => 'Settings', 'url' => '']];

// Fetch settings
try {
    $settings = $db->query("SELECT * FROM system_settings ORDER BY setting_key")->fetchAll(PDO::FETCH_ASSOC);
    $settingsArray = [];
    foreach ($settings as $s) {
        $settingsArray[$s['setting_key']] = $s['setting_value'];
    }
} catch (PDOException $e) {
    $settingsArray = [];
}

renderAdminHeader('System Settings', $breadcrumbs);
?>

<div class="mb-4">
    <h2 class="fw-bold">System Settings</h2>
    <p class="text-muted">Configure platform-wide settings</p>
</div>

<div class="row">
    <div class="col-md-8 mb-4">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-white">
                <h5 class="mb-0"><i class="bi bi-gear me-2"></i>General Settings</h5>
            </div>
            <div class="card-body">
                <form id="settingsForm">
                    <div class="mb-3">
                        <label>Site Name</label>
                        <input type="text" class="form-control" name="site_name" value="<?php echo htmlspecialchars($settingsArray['site_name'] ?? 'AIMS'); ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label>Max Upload Size (MB)</label>
                        <input type="number" class="form-control" name="max_upload_size" value="<?php echo ($settingsArray['max_upload_size'] ?? 5242880) / 1048576; ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label>AI Model</label>
                        <select class="form-select" name="ai_model">
                            <option value="claude-sonnet-4-5" <?php echo ($settingsArray['ai_model'] ?? '') === 'claude-sonnet-4-5' ? 'selected' : ''; ?>>Claude Sonnet 4.5</option>
                            <option value="claude-opus-4-5">Claude Opus 4.5</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label>Price Alert Frequency (hours)</label>
                        <input type="number" class="form-control" name="price_alert_frequency" value="<?php echo ($settingsArray['price_alert_frequency'] ?? 86400) / 3600; ?>">
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="enable_notifications" id="notif" <?php echo ($settingsArray['enable_notifications'] ?? 'true') === 'true' ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="notif">Enable Push Notifications</label>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="maintenance_mode" id="maint">
                            <label class="form-check-label" for="maint">Maintenance Mode</label>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Save Settings
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-white">
                <h6 class="mb-0"><i class="bi bi-info-circle me-2"></i>System Information</h6>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th>PHP Version:</th><td><?php echo phpversion(); ?></td></tr>
                    <tr><th>MySQL Version:</th><td><?php echo $db->query('SELECT VERSION()')->fetchColumn(); ?></td></tr>
                    <tr><th>Server:</th><td><?php echo $_SERVER['SERVER_SOFTWARE']; ?></td></tr>
                    <tr><th>Disk Space:</th><td><?php echo round(disk_free_space('/') / 1073741824, 2); ?> GB free</td></tr>
                </table>
            </div>
        </div>
        
        <div class="card shadow-sm border-0">
            <div class="card-header bg-danger text-white">
                <h6 class="mb-0"><i class="bi bi-exclamation-triangle me-2"></i>Danger Zone</h6>
            </div>
            <div class="card-body">
                <button class="btn btn-outline-danger btn-sm w-100 mb-2" onclick="clearCache()">
                    <i class="bi bi-trash me-2"></i>Clear Cache
                </button>
                <button class="btn btn-outline-danger btn-sm w-100 mb-2" onclick="resetStats()">
                    <i class="bi bi-arrow-clockwise me-2"></i>Reset Statistics
                </button>
                <button class="btn btn-danger btn-sm w-100" onclick="factoryReset()">
                    <i class="bi bi-exclamation-octagon me-2"></i>Factory Reset
                </button>
            </div>
        </div>
    </div>
</div>

<script>
$('#settingsForm').submit(function(e) {
    e.preventDefault();
    const btn = $(this).find('button[type="submit"]');
    btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Saving...');
    
    $.post(APP_URL + '/api/admin.php', $(this).serialize() + '&action=update_settings')
    .done(function(r) {
        if (r.success) {
            showToast(r.message, 'success');
        } else {
            showToast(r.message, 'error');
        }
        btn.prop('disabled', false).html('<i class="bi bi-check-circle me-2"></i>Save Settings');
    });
});

function clearCache() {
    Swal.fire({
        title: 'Clear Cache?',
        icon: 'warning',
        showCancelButton: true
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(APP_URL + '/api/admin.php', {action: 'clear_cache'})
            .done(function(r) {
                showToast(r.message, 'success');
            });
        }
    });
}

function resetStats() {
    Swal.fire({
        title: 'Reset Statistics?',
        text: 'This will clear all analytics data',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#ef4444'
    }).then((result) => {
        if (result.isConfirmed) {
            showToast('Feature coming soon', 'info');
        }
    });
}

function factoryReset() {
    Swal.fire({
        title: 'FACTORY RESET?',
        text: 'This will DELETE ALL DATA! This cannot be undone!',
        icon: 'error',
        input: 'text',
        inputPlaceholder: 'Type RESET to confirm',
        showCancelButton: true,
        confirmButtonColor: '#ef4444',
        confirmButtonText: 'Yes, reset everything'
    }).then((result) => {
        if (result.isConfirmed && result.value === 'RESET') {
            showToast('Contact system administrator for factory reset', 'error');
        }
    });
}
</script>

<?php renderAdminFooter(); ?>