<?php
/**
 * ============================================================================
 * ai-assistant/ajax/check-api.php - Check OpenAI API Status
 * ============================================================================
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../../config/config.php';

header('Content-Type: application/json; charset=utf-8');

if (!isLoggedIn()) {
    echo json_encode(['configured' => false, 'message' => 'Unauthorized']);
    exit;
}

try {
    // Check if OpenAI is configured
    $apiKey = $_ENV['OPENAI_API_KEY'] ?? '';
    
    $configured = !empty($apiKey) && 
                  $apiKey !== 'your_openai_api_key' &&
                  strpos($apiKey, 'sk-') === 0;
    
    echo json_encode([
        'configured' => $configured,
        'model' => $_ENV['OPENAI_MODEL'] ?? 'gpt-3.5-turbo',
        'message' => $configured ? 'OpenAI is configured and active' : 'Using rule-based responses'
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'configured' => false,
        'message' => 'Error checking API status'
    ]);
}