<?php
/**
 * ============================================================================
 * ai-assistant/ajax/clear-history.php - Clear Conversation History
 * ============================================================================
 */

// Security check
define('AIMS_ACCESS', true);

// Load configuration
require_once __DIR__ . '/../../config/config.php';

// Set JSON header
header('Content-Type: application/json; charset=utf-8');

// Check authentication
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// Check if POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

try {
    $userId = getUserId();
    
    // Create AI assistant instance
    require_once __DIR__ . '/../../classes/AIAssistant.php';
    $ai = new \App\AIAssistant();
    
    // Clear history
    $result = $ai->clearHistory($userId);
    
    if ($result) {
        echo json_encode([
            'success' => true,
            'message' => 'History cleared successfully'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Error clearing history'
        ]);
    }
    
} catch (Exception $e) {
    error_log('Clear History Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error clearing history'
    ]);
}