<?php
/**
 * ============================================================================
 * ai-assistant/ajax/load-session.php - Load Session Messages
 * ============================================================================
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../../config/config.php';

header('Content-Type: application/json; charset=utf-8');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

try {
    $sessionId = isset($_GET['session_id']) ? $_GET['session_id'] : '';
    
    if (empty($sessionId)) {
        echo json_encode(['success' => false, 'message' => 'Session ID required']);
        exit;
    }
    
    require_once __DIR__ . '/../../classes/AIAssistant.php';
    $ai = new \App\AIAssistant();
    
    // Get all messages in this session
    $messages = $ai->getSessionMessages($sessionId);
    
    echo json_encode([
        'success' => true,
        'session_id' => $sessionId,
        'messages' => $messages
    ]);
    
} catch (Exception $e) {
    error_log('Load Session Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error loading session'
    ]);
}