<?php
/**
 * ============================================================================
 * ai-assistant/ajax/stats.php - Get AI Statistics
 * ============================================================================
 */

// Security check
define('AIMS_ACCESS', true);

// Load configuration
require_once __DIR__ . '/../../config/config.php';

// Set JSON header
header('Content-Type: application/json; charset=utf-8');

// Check authentication
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

try {
    $userId = getUserId();
    
    // Create AI assistant instance
    require_once __DIR__ . '/../../classes/AIAssistant.php';
    $ai = new \App\AIAssistant();
    
    // Get statistics
    $stats = $ai->getStats($userId);
    
    echo json_encode([
        'success' => true,
        'stats' => $stats
    ]);
    
} catch (Exception $e) {
    error_log('Stats Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error loading statistics'
    ]);
}