<?php
/**
 * ============================================================================
 * ajax/get-districts.php
 * Get districts by region
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonError('Unauthorized', 401);
}

$regionId = (int)($_GET['region_id'] ?? 0);

if ($regionId <= 0) {
    jsonError('Invalid region ID');
}

$database = new Database();
$db = $database->getConnection();

$sql = "SELECT id, district_name FROM districts WHERE region_id = ? ORDER BY district_name";
$stmt = $db->prepare($sql);
$stmt->execute([$regionId]);
$districts = $stmt->fetchAll();

echo json_encode($districts);
?>
