<?php
/**
 * ============================================================================
 * ajax/get-vapid-key.php
 * Return VAPID public key for client-side subscription
 * ============================================================================
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

try {
    $database = new Database();
    $db = $database->getConnection();
    
    $pushNotification = new \App\PushNotification($db);
    
    echo json_encode([
        'success' => true,
        'publicKey' => $pushNotification->getPublicKey()
    ]);
    
} catch (Exception $e) {
    error_log('VAPID key error: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Failed to get VAPID key'
    ]);
}
?>