<?php
/**
 * ============================================================================
 * ajax/mark-notification-read.php
 * Mark notification as read
 * ============================================================================
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

try {
    $userId = getUserId();
    $notificationId = $_POST['notification_id'] ?? null;
    
    if (!$notificationId) {
        throw new Exception('Notification ID required');
    }
    
    $database = new Database();
    $db = $database->getConnection();
    
    // Mark as read (only if belongs to current user)
    $sql = "UPDATE notifications SET is_read = 1 
            WHERE id = ? AND user_id = ?";
    $stmt = $db->prepare($sql);
    $stmt->execute([$notificationId, $userId]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Notification marked as read'
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Failed to mark notification as read'
    ]);
}
?>