<?php
/**
 * ============================================================================
 * ajax/send-test-notification.php
 * Send a test push notification to the user
 * ============================================================================
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

try {
    $userId = getUserId();
    $database = new Database();
    $db = $database->getConnection();
    
    $pushNotification = new \App\PushNotification($db);
    
    $result = $pushNotification->sendTestNotification($userId);
    echo json_encode($result);
    
} catch (Exception $e) {
    error_log('Test notification error: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Failed to send test notification'
    ]);
}
?>