<?php
/**
 * ============================================================================
 * ajax/update-activity.php - Update User Activity
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false]);
    exit;
}

try {
    $userId = getUserId();
    
    $database = new \App\Database();
    $db = $database->getConnection();
    
    // Update last activity
    $sql = "UPDATE users SET last_activity = NOW() WHERE id = ?";
    $stmt = $db->prepare($sql);
    $success = $stmt->execute([$userId]);
    
    echo json_encode(['success' => $success]);
    
} catch (\Exception $e) {
    error_log('Update activity error: ' . $e->getMessage());
    echo json_encode(['success' => false]);
}