<?php
/**
 * ============================================================================
 * ajax/upload.php
 * File upload handler
 * ============================================================================
 */
?>
<?php
define('AIMS_ACCESS', true);
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonError('Unauthorized', 401);
}

if (!isset($_FILES['file'])) {
    jsonError('No file uploaded');
}

$folder = sanitize($_POST['folder'] ?? 'general');
$result = uploadFile($_FILES['file'], $folder);

if ($result['success']) {
    jsonSuccess('File uploaded successfully', $result);
} else {
    jsonError($result['message'] ?? 'Upload failed');
}
?>

