<?php
/**
 * Buyer Sidebar Navigation
 * File: buyer/includes/sidebar.php
 */

$currentPage = basename($_SERVER['PHP_SELF']);

// Get pending counts
try {
    $sql = "SELECT 
                (SELECT COUNT(*) FROM orders WHERE buyer_id = ? AND status = 'pending') as pending_orders,
                (SELECT COUNT(*) FROM orders WHERE buyer_id = ? AND status IN ('confirmed', 'processing')) as active_orders,
                (SELECT COUNT(*) FROM favorites WHERE user_id = ?) as favorites_count";
    $stmt = $db->prepare($sql);
    $stmt->execute([$currentUserId, $currentUserId, $currentUserId]);
    $counts = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $counts = ['pending_orders' => 0, 'active_orders' => 0, 'favorites_count' => 0];
}
?>

<!-- Buyer Sidebar -->
<div class="buyer-sidebar">
    <!-- Dashboard -->
    <div class="nav-section-title">Main</div>
    <a href="<?php echo APP_URL; ?>/buyer/dashboard.php" class="nav-link <?php echo $currentPage === 'dashboard.php' ? 'active' : ''; ?>">
        <i class="bi bi-speedometer2"></i>
        <span>Dashboard</span>
    </a>

    <!-- Shopping & Orders -->
    <div class="nav-section-title">Shopping</div>
    
    <a href="<?php echo APP_URL; ?>/marketplace/" class="nav-link <?php echo $currentPage === 'marketplace' ? 'active' : ''; ?>">
        <i class="bi bi-shop"></i>
        <span>Browse Products</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/buyer/favorites.php" class="nav-link <?php echo $currentPage === 'favorites.php' ? 'active' : ''; ?>">
        <i class="bi bi-heart"></i>
        <span>Favorites</span>
        <?php if ($counts['favorites_count'] > 0): ?>
        <span class="badge bg-danger"><?php echo $counts['favorites_count']; ?></span>
        <?php endif; ?>
    </a>
    
    <a href="<?php echo APP_URL; ?>/buyer/orders.php" class="nav-link <?php echo $currentPage === 'orders.php' ? 'active' : ''; ?>">
        <i class="bi bi-cart-check"></i>
        <span>My Orders</span>
        <?php if ($counts['active_orders'] > 0): ?>
        <span class="badge bg-warning"><?php echo $counts['active_orders']; ?></span>
        <?php endif; ?>
    </a>
    
    <a href="<?php echo APP_URL; ?>/prices/" class="nav-link">
        <i class="bi bi-graph-up"></i>
        <span>Market Prices</span>
    </a>

    <!-- Supplier Management -->
    <?php if ($buyerSystem->hasPermission('manage_suppliers')): ?>
    <div class="nav-section-title">Suppliers</div>
    
    <a href="<?php echo APP_URL; ?>/buyer/suppliers.php" class="nav-link <?php echo $currentPage === 'suppliers.php' ? 'active' : ''; ?>">
        <i class="bi bi-people"></i>
        <span>My Suppliers</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/buyer/find-suppliers.php" class="nav-link <?php echo $currentPage === 'find-suppliers.php' ? 'active' : ''; ?>">
        <i class="bi bi-search"></i>
        <span>Find Suppliers</span>
    </a>
    <?php endif; ?>

    <!-- Bulk Purchase & Quotes -->
    <?php if ($buyerSystem->hasPermission('bulk_purchase') || $buyerSystem->hasPermission('request_quotes')): ?>
    <div class="nav-section-title">Bulk Purchasing</div>
    
    <?php if ($buyerSystem->hasPermission('request_quotes')): ?>
    <a href="<?php echo APP_URL; ?>/buyer/purchase-requests.php" class="nav-link <?php echo $currentPage === 'purchase-requests.php' ? 'active' : ''; ?>">
        <i class="bi bi-file-text"></i>
        <span>Quote Requests</span>
    </a>
    <?php endif; ?>
    
    <?php if ($buyerSystem->hasPermission('bulk_purchase')): ?>
    <a href="<?php echo APP_URL; ?>/buyer/bulk-orders.php" class="nav-link <?php echo $currentPage === 'bulk-orders.php' ? 'active' : ''; ?>">
        <i class="bi bi-boxes"></i>
        <span>Bulk Orders</span>
    </a>
    <?php endif; ?>
    
    <?php if ($buyerSystem->hasPermission('contract_farming')): ?>
    <a href="<?php echo APP_URL; ?>/buyer/contracts.php" class="nav-link <?php echo $currentPage === 'contracts.php' ? 'active' : ''; ?>">
        <i class="bi bi-file-earmark-text"></i>
        <span>Contracts</span>
    </a>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Quality & Specifications -->
    <?php if ($buyerSystem->hasPermission('quality_specifications')): ?>
    <div class="nav-section-title">Quality Control</div>
    
    <a href="<?php echo APP_URL; ?>/buyer/quality-specs.php" class="nav-link <?php echo $currentPage === 'quality-specs.php' ? 'active' : ''; ?>">
        <i class="bi bi-clipboard-check"></i>
        <span>Quality Standards</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/buyer/inspections.php" class="nav-link <?php echo $currentPage === 'inspections.php' ? 'active' : ''; ?>">
        <i class="bi bi-binoculars"></i>
        <span>Inspections</span>
    </a>
    <?php endif; ?>

    <!-- Analytics & Reports -->
    <?php if ($buyerSystem->hasPermission('view_analytics')): ?>
    <div class="nav-section-title">Analytics</div>
    
    <a href="<?php echo APP_URL; ?>/buyer/analytics.php" class="nav-link <?php echo $currentPage === 'analytics.php' ? 'active' : ''; ?>">
        <i class="bi bi-bar-chart"></i>
        <span>Analytics</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/buyer/reports.php" class="nav-link <?php echo $currentPage === 'reports.php' ? 'active' : ''; ?>">
        <i class="bi bi-file-earmark-spreadsheet"></i>
        <span>Reports</span>
    </a>
    <?php endif; ?>

    <!-- Payments & Finance -->
    <div class="nav-section-title">Finance</div>
    
    <a href="<?php echo APP_URL; ?>/buyer/payments.php" class="nav-link <?php echo $currentPage === 'payments.php' ? 'active' : ''; ?>">
        <i class="bi bi-wallet2"></i>
        <span>Payments</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/buyer/invoices.php" class="nav-link <?php echo $currentPage === 'invoices.php' ? 'active' : ''; ?>">
        <i class="bi bi-receipt"></i>
        <span>Invoices</span>
    </a>

    <!-- Communication -->
    <div class="nav-section-title">Communication</div>
    
    <a href="<?php echo APP_URL; ?>/chat/" class="nav-link">
        <i class="bi bi-chat-dots"></i>
        <span>Messages</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/buyer/reviews.php" class="nav-link <?php echo $currentPage === 'reviews.php' ? 'active' : ''; ?>">
        <i class="bi bi-star"></i>
        <span>My Reviews</span>
    </a>

    <!-- Settings & Profile -->
    <div class="nav-section-title">Settings</div>
    
    <a href="<?php echo APP_URL; ?>/buyer/settings.php" class="nav-link <?php echo $currentPage === 'settings.php' ? 'active' : ''; ?>">
        <i class="bi bi-gear"></i>
        <span>Buyer Settings</span>
    </a>
    
    <?php if (!$buyerSystem->isVerified() && in_array($buyerType, ['processor', 'exporter', 'wholesaler'])): ?>
    <a href="<?php echo APP_URL; ?>/buyer/verification.php" class="nav-link <?php echo $currentPage === 'verification.php' ? 'active' : ''; ?>">
        <i class="bi bi-patch-check text-warning"></i>
        <span>Get Verified</span>
    </a>
    <?php endif; ?>
    
    <a href="<?php echo APP_URL; ?>/buyer/help.php" class="nav-link <?php echo $currentPage === 'help.php' ? 'active' : ''; ?>">
        <i class="bi bi-question-circle"></i>
        <span>Help & Support</span>
    </a>
</div>