<?php
/**
 * buyer/suppliers.php - Supplier Management
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/BuyerSystem.php';

if (!isLoggedIn() || getUserType() !== 'buyer') {
    header('Location: ' . APP_URL . '/auth/login.php');
    exit();
}

use App\Database;
$database = Database::getInstance();
$db = $database->getConnection();
$currentUserId = getUserId();
$buyerSystem = new BuyerSystem($database, $currentUserId);

$suppliers = $buyerSystem->getSuppliers();

$pageTitle = 'My Suppliers';
$breadcrumbs = [['title' => 'Suppliers', 'url' => '']];

require_once __DIR__ . '/includes/base.php';
renderBuyerHeader($pageTitle, $breadcrumbs);
?>

<div class="card shadow-sm">
    <div class="card-header bg-white py-3">
        <div class="row align-items-center">
            <div class="col">
                <h5 class="mb-0"><i class="bi bi-people me-2"></i>My Suppliers (<?php echo count($suppliers); ?>)</h5>
            </div>
            <div class="col-auto">
                <a href="<?php echo APP_URL; ?>/buyer/find-suppliers.php" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Find New Suppliers
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php if (empty($suppliers)): ?>
            <div class="text-center py-5">
                <i class="bi bi-people" style="font-size: 4rem; color: #d1d5db;"></i>
                <h5 class="mt-3 text-muted">No suppliers yet</h5>
                <p class="text-muted">Start ordering products to build your supplier network</p>
                <a href="<?php echo APP_URL; ?>/marketplace/" class="btn btn-primary mt-2">
                    <i class="bi bi-shop me-2"></i>Browse Products
                </a>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle" id="suppliersTable">
                    <thead class="table-light">
                        <tr>
                            <th>Supplier</th>
                            <th>Location</th>
                            <th>Orders</th>
                            <th>Total Spent</th>
                            <th>Rating</th>
                            <th>Last Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($suppliers as $supplier): ?>
                        <tr>
                            <td>
                                <div>
                                    <strong><?php echo htmlspecialchars($supplier['full_name']); ?></strong><br>
                                    <small class="text-muted">
                                        <i class="bi bi-phone me-1"></i><?php echo htmlspecialchars($supplier['phone_number']); ?>
                                    </small>
                                </div>
                            </td>
                            <td>
                                <i class="bi bi-geo-alt me-1"></i>
                                <?php echo htmlspecialchars($supplier['district_name'] ?? 'N/A'); ?>
                            </td>
                            <td><span class="badge bg-primary"><?php echo $supplier['total_orders']; ?></span></td>
                            <td><strong class="text-success"><?php echo formatCurrency($supplier['total_spent']); ?></strong></td>
                            <td><?php echo getRatingStars($supplier['avg_rating']); ?></td>
                            <td><small><?php echo timeAgo($supplier['last_order_date']); ?></small></td>
                            <td>
                                <div class="btn-group">
                                    <a href="<?php echo APP_URL; ?>/chat/?user=<?php echo $supplier['id']; ?>" 
                                       class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-chat"></i>
                                    </a>
                                    <a href="<?php echo APP_URL; ?>/buyer/supplier-details.php?id=<?php echo $supplier['id']; ?>" 
                                       class="btn btn-sm btn-outline-info">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#suppliersTable').DataTable({
        order: [[4, 'desc']],
        pageLength: 25
    });
});
</script>

<?php renderBuyerFooter(); ?>