<?php
/**
 * ============================================================================
 * buyer/verification-pending.php - Buyer Verification Pending Page
 * ============================================================================
 */
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/BuyerSystem.php';

if (!isLoggedIn() || getUserType() !== 'buyer') {
    header('Location: ' . APP_URL . '/auth/login.php');
    exit();
}

use App\Database;
$database = Database::getInstance();
$db = $database->getConnection();
$currentUserId = getUserId();

// Get verification status
$sql = "SELECT * FROM user_approvals WHERE user_id = ? AND user_type = 'buyer' ORDER BY created_at DESC LIMIT 1";
$stmt = $db->prepare($sql);
$stmt->execute([$currentUserId]);
$verification = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$verification || $verification['approval_status'] !== 'pending') {
    header('Location: ' . APP_URL . '/buyer/dashboard.php');
    exit();
}

$pageTitle = 'Verification Pending';
$breadcrumbs = [['title' => 'Verification Status', 'url' => '']];

require_once __DIR__ . '/includes/base.php';
renderBuyerHeader($pageTitle, $breadcrumbs);
?>

<style>
    .pending-container {
        max-width: 600px;
        margin: 0 auto;
        text-align: center;
        padding: 3rem 0;
    }
    .status-icon {
        font-size: 5rem;
        color: #f59e0b;
        animation: pulse 2s infinite;
    }
    @keyframes pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.5; }
    }
</style>

<div class="pending-container">
    <div class="status-icon">
        <i class="bi bi-hourglass-split"></i>
    </div>
    
    <h2 class="mt-4 mb-3">Verification in Progress</h2>
    
    <p class="lead text-muted mb-4">
        Your documents are being reviewed by our team. This usually takes 1-2 business days.
    </p>
    
    <div class="card shadow-sm mb-4">
        <div class="card-body text-start">
            <h6 class="mb-3">Documents Submitted:</h6>
            <ul class="list-unstyled">
                <li class="mb-2">
                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                    Business Registration Certificate
                </li>
                <li class="mb-2">
                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                    Tax Identification Number (TIN)
                </li>
                <?php if (isset($verification['supporting_documents'])): ?>
                    <?php $docs = json_decode($verification['supporting_documents'], true); ?>
                    <?php if (isset($docs['trade_license'])): ?>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        Export Trade License
                    </li>
                    <?php endif; ?>
                <?php endif; ?>
            </ul>
            
            <hr>
            
            <p class="mb-2"><strong>Submitted On:</strong> <?php echo date('F j, Y', strtotime($verification['created_at'])); ?></p>
            <p class="mb-0"><strong>Business Name:</strong> <?php echo htmlspecialchars($verification['business_name']); ?></p>
        </div>
    </div>
    
    <div class="alert alert-info">
        <i class="bi bi-info-circle me-2"></i>
        <strong>Note:</strong> You can still browse products and contact sellers while verification is pending.
    </div>
    
    <div class="d-flex gap-2 justify-content-center">
        <a href="<?php echo APP_URL; ?>/buyer/dashboard.php" class="btn btn-primary">
            <i class="bi bi-house me-2"></i>Go to Dashboard
        </a>
        <a href="<?php echo APP_URL; ?>/marketplace/" class="btn btn-outline-primary">
            <i class="bi bi-shop me-2"></i>Browse Products
        </a>
    </div>
    
    <div class="mt-5">
        <p class="text-muted mb-2">Need help?</p>
        <a href="mailto:support@aims.ug" class="btn btn-link">
            <i class="bi bi-envelope me-2"></i>Contact Support
        </a>
    </div>
</div>

<?php renderBuyerFooter(); ?>