<?php
// ============================================================================
// config/constants.php
// ============================================================================

// User Types
define('USER_FARMER', 'farmer');
define('USER_BUYER', 'buyer');
define('USER_EXTENSION', 'extension_officer');
define('USER_ADMIN', 'admin');

// Product Categories
$PRODUCT_CATEGORIES = [
    'sugar_cane' => ['name' => 'Sugar Cane', 'icon' => '🌾', 'color' => '#22c55e'],
    'poultry' => ['name' => 'Poultry & Eggs', 'icon' => '🐔', 'color' => '#f97316'],
    'maize' => ['name' => 'Maize', 'icon' => '🌽', 'color' => '#eab308'],
    'vegetables' => ['name' => 'Vegetables', 'icon' => '🥬', 'color' => '#10b981'],
    'coffee' => ['name' => 'Coffee', 'icon' => '☕', 'color' => '#92400e'],
    'beans' => ['name' => 'Beans', 'icon' => '🫘', 'color' => '#7c2d12'],
    'cassava' => ['name' => 'Cassava', 'icon' => '🥔', 'color' => '#a16207'],
    'bananas' => ['name' => 'Bananas', 'icon' => '🍌', 'color' => '#fbbf24'],
    'dairy' => ['name' => 'Dairy Products', 'icon' => '🥛', 'color' => '#3b82f6'],
    'livestock' => ['name' => 'Livestock', 'icon' => '🐄', 'color' => '#dc2626'],
    'other' => ['name' => 'Other', 'icon' => '📦', 'color' => '#6b7280']
];

// Product Status
define('STATUS_AVAILABLE', 'available');
define('STATUS_SOLD', 'sold');
define('STATUS_RESERVED', 'reserved');
define('STATUS_EXPIRED', 'expired');

// Enterprise Status
define('ENTERPRISE_PLANNING', 'planning');
define('ENTERPRISE_PLANTED', 'planted');
define('ENTERPRISE_GROWING', 'growing');
define('ENTERPRISE_HARVESTING', 'harvesting');
define('ENTERPRISE_COMPLETED', 'completed');

// Transaction Types
define('TRANSACTION_INCOME', 'income');
define('TRANSACTION_EXPENSE', 'expense');

// Chat Types
define('CHAT_GROUP', 'group');
define('CHAT_ONE_TO_ONE', 'one_to_one');

// Message Types
define('MESSAGE_TEXT', 'text');
define('MESSAGE_IMAGE', 'image');
define('MESSAGE_DOCUMENT', 'document');
define('MESSAGE_AUDIO', 'audio');
define('MESSAGE_SYSTEM', 'system');

// Friendship Status
define('FRIEND_PENDING', 'pending');
define('FRIEND_ACCEPTED', 'accepted');
define('FRIEND_BLOCKED', 'blocked');

// Notification Types
define('NOTIFICATION_INFO', 'info');
define('NOTIFICATION_SUCCESS', 'success');
define('NOTIFICATION_WARNING', 'warning');
define('NOTIFICATION_DANGER', 'danger');

// Order Status
define('ORDER_PENDING', 'pending');
define('ORDER_CONFIRMED', 'confirmed');
define('ORDER_PROCESSING', 'processing');
define('ORDER_COMPLETED', 'completed');
define('ORDER_CANCELLED', 'cancelled');

// Payment Status
define('PAYMENT_UNPAID', 'unpaid');
define('PAYMENT_PARTIAL', 'partial');
define('PAYMENT_PAID', 'paid');

// Price Alert Conditions
define('ALERT_ABOVE', 'above');
define('ALERT_BELOW', 'below');

// Languages
define('LANG_ENGLISH', 'en');
define('LANG_LUSOGA', 'lusoga');

// Units of Measurement
$UNITS = [
    'kg' => 'Kilogram',
    'ton' => 'Ton',
    'bag' => 'Bag',
    'tray' => 'Tray',
    'piece' => 'Piece',
    'bunch' => 'Bunch',
    'liter' => 'Liter',
    'acre' => 'Acre',
    'bird' => 'Bird',
    'crate' => 'Crate',
    'sack' => 'Sack',
    'basin' => 'Basin'
];

// Districts in Eastern Uganda
$DISTRICTS = [
    'Luuka', 'Iganga', 'Jinja', 'Bugiri', 'Mayuge', 'Kamuli',
    'Buyende', 'Kaliro', 'Namutumba', 'Namayingo', 'Bugweri'
];

// Subcounties in Luuka District
$LUUKA_SUBCOUNTIES = [
    'Bukabooli', 'Bukanga', 'Ikumbya', 'Irongo', 'Kiyunga',
    'Luuka Town Council', 'Nawampiti', 'Waibuga', 'Wanseko'
];

// Agricultural Tips Categories
$TIP_CATEGORIES = [
    'crop_management' => 'Crop Management',
    'pest_control' => 'Pest & Disease Control',
    'soil_health' => 'Soil Health',
    'irrigation' => 'Irrigation',
    'harvesting' => 'Harvesting',
    'storage' => 'Storage',
    'general' => 'General Farming'
];

// Extension Service Types
$SERVICE_TYPES = [
    'farm_visit' => 'Farm Visit',
    'training' => 'Training',
    'consultation' => 'Consultation',
    'demonstration' => 'Demonstration'
];

// Transaction Categories
$INCOME_CATEGORIES = [
    'product_sale' => 'Product Sale',
    'service_income' => 'Service Income',
    'grant' => 'Grant/Subsidy',
    'loan' => 'Loan',
    'other_income' => 'Other Income'
];

$EXPENSE_CATEGORIES = [
    'seeds' => 'Seeds/Seedlings',
    'fertilizer' => 'Fertilizer',
    'pesticide' => 'Pesticides',
    'labor' => 'Labor',
    'equipment' => 'Equipment',
    'transport' => 'Transport',
    'utilities' => 'Utilities',
    'feed' => 'Animal Feed',
    'veterinary' => 'Veterinary Services',
    'other_expense' => 'Other Expenses'
];

// Application Pages (for navigation)
$APP_PAGES = [
    'dashboard' => [
        'title' => 'Dashboard',
        'url' => '/dashboard',
        'icon' => 'bi-speedometer2',
        'roles' => ['farmer', 'buyer', 'extension_officer', 'admin']
    ],
    'marketplace' => [
        'title' => 'Marketplace',
        'url' => '/marketplace',
        'icon' => 'bi-shop',
        'roles' => ['farmer', 'buyer', 'extension_officer', 'admin']
    ],
    'prices' => [
        'title' => 'Market Prices',
        'url' => '/prices',
        'icon' => 'bi-graph-up',
        'roles' => ['farmer', 'buyer', 'extension_officer', 'admin']
    ],
    'farm' => [
        'title' => 'My Farm',
        'url' => '/farm',
        'icon' => 'bi-tree',
        'roles' => ['farmer']
    ],
    'chat' => [
        'title' => 'Messages',
        'url' => '/chat',
        'icon' => 'bi-chat-dots',
        'roles' => ['farmer', 'buyer', 'extension_officer', 'admin']
    ],
    'ai_assistant' => [
        'title' => 'AI Assistant',
        'url' => '/ai-assistant',
        'icon' => 'bi-robot',
        'roles' => ['farmer', 'buyer', 'extension_officer', 'admin']
    ],
    'learning' => [
        'title' => 'Learning Center',
        'url' => '/learning',
        'icon' => 'bi-book',
        'roles' => ['farmer', 'buyer', 'extension_officer', 'admin']
    ],
    'friends' => [
        'title' => 'Friends',
        'url' => '/friends',
        'icon' => 'bi-people',
        'roles' => ['farmer', 'buyer', 'extension_officer']
    ],
    'admin' => [
        'title' => 'Admin Panel',
        'url' => '/admin',
        'icon' => 'bi-gear',
        'roles' => ['admin']
    ]
];

?>
