<?php
/**
 * ============================================================================
 * knowledge-base-lusoga.php - Lusoga Knowledge Base
 * ============================================================================
 * Pattern-based responses for agricultural questions in Lusoga language
 */

return [
    // ============================================================================
    // AMAGAMBO G'OKUSAALIRA (GREETINGS)
    // ============================================================================
    '/^(wasuze|osiibiile|oli otya|osiibiile nyo|hello|hi|hey|suubi)/i' =>
        "Nsiibiile nyo! 👋 Ndi musanyufu okukuwulira!\n\n" .
        "Nze **AIM AI**, omuyambi wo mu by'obulimi mu Uganda. Ndi wano okukuyamba okufuna omukisa mu by'obulimi!\n\n" .
        "**Ndiyinza okukuyamba mu:**\n" .
        "🌱 **Obulwadhe bw'ebirime n'ebiwuka** - Okuzuula n'okujjanjaba\n" .
        "📅 **Okusimba** - Okumanyi obudde obwokusimba\n" .
        "💰 **Emiwendo gy'ebintu** - Okufuna emiwendo egiriwo kaakati\n" .
        "🌾 **Enkola ennungi z'okulima** - Okuyiga engeri empya\n" .
        "🐔 **Okulunda ebisolo** - Enkoko, ente, embuzi\n" .
        "☀️ **Obudde** - Amagezi g'okulima\n\n" .
        "**Osobola okumbuuza mu Lungereza oba Lusoga!**\n" .
        "Oyagala okumanyi ki? 🚜",

    '/oli otya|biriwo|how are you/i' =>
        "Ndi bulungi nnyo, webale! 😊\n\n" .
        "Ndi mwetegefu okuyamba abalimi nga ggwe okufuna omukisa! Oyinza okumbuuza ku:\n" .
        "- Okuzuula obulwadhe bw'ebirime\n" .
        "- Obudde obwokusimba\n" .
        "- Emiwendo gy'ebintu mu bbabali\n" .
        "- Okuddukanya omusimu bulungi\n\n" .
        "Mbuuza kyonna kyoyagala okumanyi ku by'obulimi! 🌾",

    // ============================================================================
    // OBULO (KASOOLI/MAIZE)
    // ============================================================================
    '/obulo.*bulwadhe|kasooli.*bulwadhe|obulwadhe.*bwa.*obulo|rust.*obulo/i' =>
        "**🌽 Okufuga Obulwadhe bwa Rust ku Kasooli**\n\n" .
        "**Obubonero:**\n" .
        "- Amatutumba amatonotono ama brown ku bikoola\n" .
        "- Rust erabika ku njuyi zombi z'ekikoola\n" .
        "- Amasenge ga orange/yellow bwe gasiikulula\n" .
        "- Ebikoola bikala mangu\n\n" .
        "**Engeri z'okukozesa:**\n\n" .
        "**1. Eddagala ly'obuwuka:**\n" .
        "- Fumunya **Mancozeb** oba **Metalaxyl**\n" .
        "- Fumunya obulwadhe nga bwakatandika\n" .
        "- Damu fumunya oluvannyuma lw'ennaku 14\n" .
        "- Emiwendo: UGX 15,000-25,000 buli kilo\n\n" .
        "**2. Ensigo eziriko obusika (Ezisingako obulungi):**\n" .
        "- **Longe 10H** - Ziriko obusika bungi\n" .
        "- **DH04** - Ziriko obusika, amakungula mangi\n" .
        "- **Longe 5** - Zisobola okwegumira\n" .
        "- **NASE varieties** - Ensigo za Uganda\n\n" .
        "**3. Enkola z'okulima:**\n" .
        "- Kyusa ebirime (simba bikooge oba ebinyeebwa)\n" .
        "- Malawo ebisigadde by'ebirime oluvannyuma lw'okungula\n" .
        "- Leka ekifo ekimala wakati w'ebirime (75cm x 30cm)\n" .
        "- Teeka NPK fertilizer\n\n" .
        "**4. Okuziyiza:**\n" .
        "- Kozesa ensigo eziriko certificate, ezitaliiko bulwadhe\n" .
        "- Simba mu season entuufu\n" .
        "- Weewale okufukirira kungulu ku bikoola\n" .
        "- Londa omusimu, ggya omuddo\n\n" .
        "💡 **Amagezi:** Simba mangu (enkuba nga yakatandika) okwewala rust!",

    '/fall.*armyworm|armyworm|ebiwuka.*birya.*kasooli|enjooka.*kasooli/i' =>
        "**🐛 Okufuga Ebiwuka bya Fall Armyworm**\n\n" .
        "**Engeri y'okubizuula:**\n" .
        "- Enjooka za green/brown eziriko emiggo emiragavu\n" .
        "- Akabonero ka \"Y\" akeeru ku mutwe\n" .
        "- Zirya ebikoola, zikola ebituli\n" .
        "- Zekweka mu whorl emisana\n" .
        "- Zikyuka ekiro\n\n" .
        "**Engeri z'okuzikozesa:**\n\n" .
        "**1. Okuzikwata n'engalo (Kyereere!):**\n" .
        "- Kebera ebirime buli makya\n" .
        "- Kwata enjooka n'engalo mu whorl\n" .
        "- Zisuule mu mazzi g'esabuuni\n" .
        "- Gonda amagi ku bikoola\n\n" .
        "**2. Eddagala ly'omu maka:**\n" .
        "**Evvu n'esabuuni:**\n" .
        "- Tabaganya evvu ly'embaawo ne sabuuni\n" .
        "- Teekamu amazzi matono\n" .
        "- Suulamu mu whorl\n" .
        "- Damu kola buli nnaku 3\n\n" .
        "**Amafuta g'omukeene:**\n" .
        "- 50g omukeene ogusekese mu 1 lita amazzi\n" .
        "- Bisiba ekiro, sengula\n" .
        "- Teekamu 1 tablespoon esabuuni\n" .
        "- Fumunya kumakya oba akawungeezi\n\n" .
        "**Garlic-Chili Spray:**\n" .
        "- Sega tunnyabulago 10 ne kasooli akabaalu 5\n" .
        "- Teekamu 1 lita amazzi, sengula\n" .
        "- Fumunya ku birime buli wiiki\n\n" .
        "**3. Eddagala ery'obuwuka mu maduuka:**\n" .
        "- **Emamectin benzoate** (Belt, Escort)\n" .
        "- **Chlorantraniliprole** (Ampligo)\n" .
        "- **Profenofos** (Curacron)\n" .
        "- Fumunya kumakya oba akawungeezi\n" .
        "- Fukunula whorl n'ebirime ebito\n\n" .
        "**Okuziyiza:**\n" .
        "- Simba mangu mu season\n" .
        "- Kozesa ensigo eziriko obusika\n" .
        "- Simba wamu ne bikooge oba ebinyeebwa\n" .
        "- Malawo ebisigadde by'ebirime\n" .
        "- Kebera omusimu buli kaseera\n\n" .
        "💡 **Okukekkereza ssente:** Tandika n'okukwata n'engalo + eddagala ly'omu maka ng'otonagula mu maduuka!",

    '/obulo.*okusimba|kasooli.*okusimba|dijja.*okusimba.*kasooli/i' =>
        "**📅 Obudde bw'okusimba Obulo mu Uganda**\n\n" .
        "**Obudde obusingako obulungi:**\n\n" .
        "**Season 1 (Enkulu):**\n" .
        "- **March - April** (Tandika n'enkuba esooka)\n" .
        "- Esingako obulungi ku kungula\n" .
        "- Okungula: July - August\n\n" .
        "**Season 2:**\n" .
        "- **August - September**\n" .
        "- Season empi\n" .
        "- Okungula: December - January\n\n" .
        "**Ebyeetaagisa:**\n" .
        "- Enkuba: Obusa 500mm mu season yonna\n" .
        "- Ebbugumu: 18-27°C ekisingako obulungi\n" .
        "- Ettaka erikalagira amazzi\n" .
        "- pH 5.5-7.5\n\n" .
        "**Engeri y'okusimba:**\n\n" .
        "**Ekifo:**\n" .
        "- Wakati w'ennyiriri: **75cm**\n" .
        "- Mu nnyiriri: **25-30cm**\n" .
        "- Ensigo 2 mu kituli, oluvannyuma londa omu\n\n" .
        "**Ensigo:**\n" .
        "- 10-15kg buli acre\n\n" .
        "**Fertilizer:**\n" .
        "- **Wakati w'okusimba:** DAP 50kg/acre\n" .
        "- **Oluvannyuma lw'ennaku 28:** Urea 50kg/acre (top dressing)\n" .
        "- **Oba NPK (17:17:17):** 100kg/acre okugabanya\n\n" .
        "**Ensigo ezisingako obulungi mu Uganda:**\n" .
        "- **Longe 10H** - Ennaku 120, kungula 8-10 tons/acre\n" .
        "- **Longe 5** - Ennaku 110, zisobola ekyeya\n" .
        "- **DH04** - Ennaku 120, ziriko obusika ku bulwadhe\n" .
        "- **NASE 4 Good** - Ennaku 115\n" .
        "- **PAN 691** - Hybrid, kungula mangi\n\n" .
        "**Ennaku enkulu:**\n" .
        "- Okusimula omuddo: Ennaku 3 ne 6 oluvannyuma lw'okusimba\n" .
        "- Top dressing: Ennaku 28\n" .
        "- Okuvaamu: Ennaku 100-130\n" .
        "- Okungula: Obunnyogovu nga buli <13.5%\n\n" .
        "💡 **Amagezi:** Simba mu nnaku 2 okuva enkuba lwe yakatandika!",

    '/emiwendo.*obulo|price.*kasooli|okutunda.*obulo/i' =>
        "**💰 Emiwendo gy'Obulo (Kasooli)**\n\n" .
        "**Emiwendo gakakati (Eastern Uganda):**\n" .
        "- **Farm Gate:** UGX 800-1,200 buli kilo\n" .
        "- **Mu bbabali:** UGX 1,000-1,500 buli kilo\n" .
        "- **Omutindo gwa kungulu:** UGX 1,200-1,800 buli kilo\n\n" .
        "*Emiwendo gikyuka nga season n'omutindo*\n\n" .
        "**Obudde obwokutunda:**\n" .
        "- **December - February:** Emiwendo gya kungulu (ebiseera ebya bbula)\n" .
        "- **August - October:** Emiwendo miguddeko (okungula)\n\n" .
        "**Okufuna emiwendo amanyi:**\n\n" .
        "**1. Omutindo gusingako:**\n" .
        "- Kaza bulungi (obunnyogovu <13.5%)\n" .
        "- Ggya obulo obwonoonese\n" .
        "- Londa n'oteeka mu bifo bya nsimbi\n" .
        "- Weewale aflatoxin\n\n" .
        "**2. Enkola y'okutereka:**\n" .
        "- Kozesa ensawo ezikuumamu obulungi (PICS bags)\n" .
        "- Tereka mu kifo ekikalu, ekikale\n" .
        "- Kebera buli kaseera\n" .
        "- Tunda emiwendo nga giri waggulu (Dec-Feb)\n\n" .
        "**3. Okutunda:**\n" .
        "- **Direct ku banagula:** Emiwendo gya kungulu naye weetaaga ebingi\n" .
        "- **Ebibiina by'abalimi:** Musobola okwogera bulungi\n" .
        "- **Abasuubuzi b'omu kitundu:** Ssente mangu naye emiwendo miguddeko\n" .
        "- **AIMS Marketplace:** Sisinkana n'abagula!\n\n" .
        "**4. Okwongera omuwendo:**\n" .
        "- Okuggyamu ebikuta: +UGX 50-100/kg\n" .
        "- Okulonda: +UGX 100-200/kg\n" .
        "- Okunaazisa: +UGX 50/kg\n\n" .
        "💡 **Kozesa AIMS Marketplace** okw:\n" .
        "- Teekawo obulo bwo okutunda\n" .
        "- Geraageranya emiwendo okuva ku bagula abalala\n" .
        "- Teekawo alerts za miwendo\n" .
        "- Sisinkana butereevu n'abagula",

    // ============================================================================
    // EBIKOOGE (BEANS)
    // ============================================================================
    '/ebikooge.*okusimba|bikooge.*dijja.*okusimba|beans.*planting/i' =>
        "**🫘 Okusimba Ebikooge mu Uganda**\n\n" .
        "**Obudde obusingako obulungi:**\n\n" .
        "**Season 1:**\n" .
        "- **February - March**\n" .
        "- Season enkulu, okungula okungi\n" .
        "- Okungula: May - June\n\n" .
        "**Season 2:**\n" .
        "- **August - September**\n" .
        "- Season empi\n" .
        "- Okungula: November - December\n\n" .
        "**Ebyeetaagisa:**\n" .
        "- Enkuba: Obusa 300mm\n" .
        "- Ebbugumu: 18-24°C ekisingako obulungi\n" .
        "- Ettaka erikalagira amazzi, pH 6.0-7.5\n" .
        "- Weewala ebifo ebikuŋŋaana amazzi\n\n" .
        "**Engeri y'okusimba:**\n\n" .
        "**Ekifo:**\n" .
        "- Wakati w'ennyiriri: **50cm**\n" .
        "- Mu nnyiriri: **10cm**\n" .
        "- Obuziba: **3-5cm**\n" .
        "- Ensigo 1-2 mu kituli\n\n" .
        "**Ensigo:**\n" .
        "- 40-50kg buli acre\n" .
        "- Emiwendo: UGX 50,000-80,000\n\n" .
        "**Fertilizer:**\n" .
        "- **DAP:** 50kg/acre wakati w'okusimba\n" .
        "- Ebikooge bisobola okufuna nitrogen ku bwazo\n" .
        "- Top dress singa ettaka si nzito\n\n" .
        "**Ensigo ezisingako obulungi:**\n\n" .
        "**Climbing Beans:**\n" .
        "- **NABE 15** - Ennaku 90, 2.5 tons/acre\n" .
        "- **NABE 16** - Ennaku 90, ezisinga mu bbabali\n" .
        "- **NABE 17** - Ennaku 85, zisobola ekyeya\n\n" .
        "**Bush Beans:**\n" .
        "- **K132** - Ennaku 75, ziriko obusika\n" .
        "- **K131** - Ennaku 80\n" .
        "- **NABE 4** - Ennaku 75, kungula mangi\n\n" .
        "**Okuddukanya:**\n" .
        "- Simula omuddo emirundi 2-3\n" .
        "- Teekawo emiti (stakes) mu nnaku 14 climbing beans\n" .
        "- Raba aphids ne bean fly\n" .
        "- Fumunya singa byeetaagisa\n\n" .
        "**Okungula:**\n" .
        "- Ebikuta 90% nga bikaze\n" .
        "- Kaza mu njuba okusa 13% obunnyogovu\n" .
        "- Tereka mu kifo ekikale, ekikalu\n\n" .
        "💡 **Simba wamu ne kasooli** okukozesa ettaka bulungi!",

    '/ebikooge.*bulwadhe|beans.*aphids|ebiwuka.*ku.*bikooge/i' =>
        "**🫘 Ebizibu ku Bikooge n'Okubikozesa**\n\n" .
        "**1. Aphids (Ebiwuka ebitonotono)**\n\n" .
        "**Obubonero:**\n" .
        "- Ebiwuka ebitonotono ebiddugavu ku bikoola/emiggo\n" .
        "- Ebikoola ebirongoose, ebikyuse\n" .
        "- Honeydew (omubisi ogw'okuwuuba) ku birime\n" .
        "- Ebirime ebitakula\n\n" .
        "**Okubikozesa:**\n" .
        "**Engeri z'obuwangwa:**\n" .
        "- Fumunya amazzi g'esabuuni (2 tbsp sabuuni/lita)\n" .
        "- Amafuta g'omukeene\n" .
        "- Okumansira evvu ly'embaawo\n" .
        "- Ggya ebirime ebiriko ebiwuka bingi\n\n" .
        "**Eddagala ly'obuwuka:**\n" .
        "- Imidacloprid (Confidor)\n" .
        "- Acetamiprid (Rescate)\n" .
        "- Lambda-cyhalothrin (Karate)\n\n" .
        "**2. Bean Fly**\n\n" .
        "**Obubonero:**\n" .
        "- Enjooka mu miggo\n" .
        "- Ebirime ebito ebikala\n" .
        "- Ebirime byafa\n\n" .
        "**Okubikozesa:**\n" .
        "- Jjanjaba ensigo nga tonnasimba\n" .
        "- Kozesa eddagala ku nsigo\n" .
        "- Simba mangu\n" .
        "- Ggya ebirime ebikalye\n\n" .
        "**3. Angular Leaf Spot**\n\n" .
        "**Obubonero:**\n" .
        "- Amatutumba aga brown ku bikoola\n" .
        "- Amatutumba galiko border ya yellow\n" .
        "- Ebikoola bigwa\n\n" .
        "**Okubikozesa:**\n" .
        "- Kozesa ensigo eziriko certificate\n" .
        "- Fumunya copper fungicides\n" .
        "- Ggya ebisigadde by'ebirime ebirwadhe\n" .
        "- Kyusa ebirime\n\n" .
        "**Okuziyiza:**\n" .
        "- Kozesa ensigo eziriko certificate\n" .
        "- Leka ekifo ekimala wakati w'ebirime\n" .
        "- Kebera omusimu buli kaseera\n" .
        "- Ggya ebirime ebirwadhe mangu\n" .
        "- Kyusa ebirime (tolima bikooge buli season)\n\n" .
        "💡 **Okukebera buli wiiki** kuyamba okuzuula ebizibu mangu!",

    // ============================================================================
    // MUWOGO (CASSAVA)
    // ============================================================================
    '/muwogo.*bulwadhe|cassava.*brown.*streak|obulwadhe.*bwa.*muwogo/i' =>
        "**🌿 Okufuga Obulwadhe bwa Muwogo**\n\n" .
        "**1. Cassava Brown Streak Disease (CBSD)**\n\n" .
        "**Obubonero:**\n" .
        "- Amabala ga yellow/brown ku bikoola\n" .
        "- Emiggo gya brown munda mu muwogo\n" .
        "- Ebikoola bikala (yellowing)\n" .
        "- Ebirime ebitakula bulungi\n" .
        "- Omuwendo gw'emisimbe gukendeera\n\n" .
        "**Okukozesa:**\n" .
        "✅ **Kozesa Enzigu ezitaliiko bulwadhe:**\n" .
        "- Fuuna enzigu okuva mu masimu agalungi\n" .
        "- Kozesa ekitundu eky'omumakkati\n" .
        "- Weewale enzigu eziva mu birime ebirwadhe\n\n" .
        "✅ **Simba Ensigo eziriko obusika:**\n" .
        "- **NASE 14** (Ziriko obusika bungi)\n" .
        "- **NASE 19** (Zisobola okwegumira)\n" .
        "- **Mkumba** (Ziriko obusika)\n" .
        "- **NASE 3** (Ziriko obusika obutono)\n\n" .
        "✅ **Okulongoosa omusimu:**\n" .
        "- Ggya n'oyokya ebirime ebirwadhe\n" .
        "- Tokozesa birime ebirwadhe ku nzigu\n" .
        "- Funga whiteflies (ezisimbisa bulwadhe)\n\n" .
        "**2. Cassava Mosaic Disease (CMD)**\n\n" .
        "**Obubonero:**\n" .
        "- Ensengeka za yellow-white ku bikoola\n" .
        "- Ebikoola ebikyuse n'ebirongose\n" .
        "- Ebirime ebitakula nnyo (ekitalo)\n" .
        "- Omuwendo gukendeera (okutuusa 90%!)\n\n" .
        "**Okukozesa:**\n" .
        "✅ **Ensigo eziriko obusika (Ezisingako):**\n" .
        "- **NASE 1**\n" .
        "- **NASE 3**\n" .
        "- **TME 14**\n" .
        "- **NASE 18**\n\n" .
        "✅ **Roguing (Kikulu nnyo!):**\n" .
        "- Ggya ebirime ebirwadhe mu myezi 2 esooka\n" .
        "- Bimaleewo ddala\n" .
        "- Kino kiziyiza okusaasaana\n\n" .
        "✅ **Okufuga ebiwuka:**\n" .
        "- Funga whiteflies n'amafuta g'omukeene\n" .
        "- Oba fumunya Imidacloprid\n\n" .
        "**Okuziyiza:**\n\n" .
        "**1. Enzigu ezilungi:**\n" .
        "- Kozesa enzigu ezikakanyavu (25-30cm)\n" .
        "- Eziva mu birime eby'emyezi 8-12 ebilungi\n" .
        "- Ekitundu eky'omumakkati kye kisingako\n" .
        "- Simba mu saawa 24 oluvannyuma lw'okutema\n\n" .
        "**2. Enkola mu musimu:**\n" .
        "- Kyusa ebirime (emyaka 3-4)\n" .
        "- Leka ekifo ekimala (1m x 1m)\n" .
        "- Funga omuddo\n" .
        "- Ggya ebirime bye wasimbangako\n\n" .
        "**3. Okungula:**\n" .
        "- Emyezi 10-12 ensigo ezisinga\n" .
        "- Emyezi 12-18 muwogo gw'amakolero\n" .
        "- Kolamu mu saawa 24-48\n\n" .
        "💡 **Ekisingako obukulu:** Kozesa ensigo eziriko obusika n'enzigu ezitaliiko bulwadhe!",

    '/muwogo.*okusimba|cassava.*planting|dijja.*okusimba.*muwogo/i' =>
        "**🌿 Okusimba Muwogo**\n\n" .
        "**Obudde obusingako obulungi:**\n" .
        "- **Entandikwa y'enkuba** (March-April oba Sept-Oct)\n" .
        "- Ettaka libeere eririko obunnyogovu naye si bungi nnyo\n" .
        "- Muwogo geetaaga emyezi 8-12, tegeera obudde bw'okungula\n\n" .
        "**Enkola y'okusimba:**\n\n" .
        "**1. Okutegeka Enzigu:**\n" .
        "- Kozesa ebirime ebilungi eby'emyezi 8-12\n" .
        "- Tema emiggo mu bitundu bya 25-30cm\n" .
        "- Kozesa ekitundu eky'omumakkati (kisinga okw'okungulu/wansi)\n" .
        "- Buli kitengo kibeere kiriko nodes 5-7\n" .
        "- Simba mu saawa 24 oluvannyuma lw'okutema\n\n" .
        "**2. Okutegeka Ettaka:**\n" .
        "- Londa omusimu bulungi\n" .
        "- Kola entumbi oba ennyiriri (si kyetaagisa naye kisinga)\n" .
        "- Teekamu obusa singa olina (5 tons/acre)\n\n" .
        "**3. Ekifo:**\n" .
        "- **1 meter x 1 meter** (standard)\n" .
        "- Kino kiwa ebirime 4,000 buli acre\n" .
        "- Ekifo ekimpi (0.8m x 0.8m) okungula mangu\n\n" .
        "**4. Engeri y'okusimba:**\n" .
        "- Simba enzigu nga ziri ku degree 45 oba flat\n" .
        "- Zika 2/3 mu ttaka\n" .
        "- Leka 1/3 (nodes 2-3) kungulu\n" .
        "- Nyweza ettaka okwetooloola omukolo\n\n" .
        "**Enzigu ebyeetaagisa:**\n" .
        "- 4,000-6,000 enzigu buli acre\n" .
        "- Fuuna okuva mu kifo ekikkirizibwa oba omusimu gwo\n" .
        "- Emiwendo: UGX 50-100 buli kigwo\n\n" .
        "**Ensigo ezisingako obulungi:**\n\n" .
        "**Ezikungula nnyo:**\n" .
        "- **NASE 14** - 35-40 tons/acre, ziriko obusika ku CBSD\n" .
        "- **NASE 19** - 30-35 tons/acre\n" .
        "- **NASE 3** - Zivaamu mangu\n\n" .
        "**Eziriko obusika ku bulwadhe:**\n" .
        "- **TME 14** - Ziriko obusika ku CMD\n" .
        "- **Mkumba** - Ziriko obusika ku CBSD\n" .
        "- **NASE 18** - Ziriko obusika ku bulwadhe bungi\n\n" .
        "**Okuddukanya:**\n" .
        "- **1st weeding:** Omwezi 1 oluvannyuma lw'okusimba\n" .
        "- **2nd weeding:** Omyezi 3\n" .
        "- **3rd weeding:** Emyezi 5 (singa kyeetaagisa)\n" .
        "- Fertilizer si kyeetaagibwa\n" .
        "- Kebera obulwadhe buli kaseera\n\n" .
        "**Okungula:**\n" .
        "- **Emyezi 10-12:** Muwogo gw'okulya\n" .
        "- **Emyezi 12-18:** Muwogo gw'amakolero\n" .
        "- Tolwa >18 emyezi (omuwendo gukakanyavu)\n" .
        "- Ungula mu kyeya\n\n" .
        "**Okungula okusuubirwa:**\n" .
        "- Okuddukanya okulungi: 25-40 tons/acre\n" .
        "- Average: 15-20 tons/acre\n" .
        "- Okuddukanya okubi: <10 tons/acre\n\n" .
        "💡 **Amagezi:** Simba wamu ne bikooge mu myezi 3-4 esooka okufuna ssente endala!",

    // ============================================================================
    // ETTAKA (SOIL)
    // ============================================================================
    '/ettaka.*okuzuukusa|fertilizer|okuzuukusa|ettaka.*fertilizer/i' =>
        "**🌾 Okuzuukusa Ettaka n'Okuteekamu Fertilizer**\n\n" .
        "**Engeri z'Obuwangwa:**\n\n" .
        "**1. Compost:**\n" .
        "- Tabaganya: ebisigadde by'ebirime + obusa + ebiva mu ffumbiro\n" .
        "- Teekawo layer brown (bikalu) ne green (biggya)\n" .
        "- Leka ebinyogovu, kyusa buli wiiki\n" .
        "- Vaamu mu myezi 2-3\n" .
        "- Teekamu: 5-10 tonnes buli acre\n\n" .
        "**2. Obusa bw'ebisolo:**\n" .
        "- **Ente/Embuzi:** 10 tonnes/acre\n" .
        "- **Enkoko:** 3-5 tonnes/acre (nitrogen nnyingi)\n" .
        "- **Embizzi:** 8 tonnes/acre\n" .
        "- Teekamu wiiki 2-3 nga tonnasimba\n\n" .
        "**3. Green Manure (Ebirime by'okuzuukusa):**\n" .
        "- Simba ebinyeebwa: bikooge, peas, mucuna\n" .
        "- Bifuna nitrogen okuva mu mpola\n" .
        "- Bimeewo mu ttaka nga tebinnamera\n\n" .
        "**4. Mulching:**\n" .
        "- Kozesa omuddo, ebikoola, ebisigadde by'ebirime\n" .
        "- Bikuuma obunnyogovu, biteekamu organic matter\n" .
        "- Teekamu layer ya 5-10cm\n\n" .
        "**Fertilizer ezikoleddwa:**\n\n" .
        "**1. DAP (Diammonium Phosphate):**\n" .
        "- **Ddi:** Wakati w'okusimba\n" .
        "- **Omuwendo:** 50kg/acre\n" .
        "- **Nutrients:** Phosphorus nnyingi (18-46-0)\n" .
        "- **Esingako:** Emirandira, okumula\n\n" .
        "**2. Urea:**\n" .
        "- **Ddi:** Top dressing, wiiki 4-6 oluvannyuma lw'okusimba\n" .
        "- **Omuwendo:** 50kg/acre\n" .
        "- **Nutrients:** Nitrogen nnyingi (46-0-0)\n" .
        "- **Esingako:** Okukula kw'ebikoola, langi ya green\n\n" .
        "**3. NPK (17:17:17):**\n" .
        "- **Ddi:** Wakati w'okusimba oba okugabanya\n" .
        "- **Omuwendo:** 100kg/acre\n" .
        "- **Nutrients:** Balanced\n" .
        "- **Esingako:** Okukula okwa bulijjo\n\n" .
        "**4. CAN (Calcium Ammonium Nitrate):**\n" .
        "- **Omuwendo:** 50kg/acre\n" .
        "- **Nutrients:** Nitrogen + Calcium\n" .
        "- **Esingako:** Top dressing\n\n" .
        "**Okugezesa Ettaka:**\n" .
        "- Genda ku NARL Kawanda oba district agricultural office\n" .
        "- Emiwendo: UGX 20,000-50,000\n" .
        "- Funa amagezi agalagiddwa\n\n" .
        "**Engeri y'okuteekamu:**\n" .
        "- Teeka fertilizer 5cm okuva ku kirime\n" .
        "- Bikke n'ettaka oluvannyuma lw'okuteeka\n" .
        "- Teeka nga ettaka liriko obunnyogovu\n" .
        "- Toteeka ng'enkuba ekube nnyo\n\n" .
        "💡 **Tabaganya engeri z'obuwangwa n'ezikoleddwa** okufuna ebisingako!",

    // ============================================================================
    // ENKOKO (POULTRY)
    // ============================================================================
    '/enkoko|poultry|layers|broilers|okulunda.*enkoko/i' =>
        "**🐔 Okulunda Enkoko**\n\n" .
        "**Ebika by'Enkoko:**\n\n" .
        "**1. Layers (Ezizaala Amagi):**\n" .
        "- Entandikwa okuzaala: wiiki 18-22\n" .
        "- Okuzaala okungi: wiiki 25-30\n" .
        "- Ekiseera ky'okuzaala: wiiki 72\n" .
        "- Emmere: Layers mash/pellets\n" .
        "- Ebika: Kuroiler, KABIR, Kenbro\n\n" .
        "**2. Broilers (Eziriddwa Ennyama):**\n" .
        "- Obudde bw'okutunda: wiiki 6-8\n" .
        "- Obuzito: 1.5-2.5 kg\n" .
        "- Emmere: Starter, Grower, Finisher\n" .
        "- Ebika: Cobb 500, Ross 308\n\n" .
        "**3. Dual Purpose:**\n" .
        "- Kuroiler, Rainbow Rooster\n" .
        "- Amagi + ennyama\n" .
        "- Ziriko obusika, zisobola okwegumira\n\n" .
        "**Amayumba:**\n" .
        "- Ekifo: 4-5 enkoko buli m²\n" .
        "- Ventilation: Kikulu!\n" .
        "- Obutangaavu: saawa 14-16 layers\n" .
        "- Nesting boxes: 1 buli 4 enkoko\n\n" .
        "**Okuliisa:**\n" .
        "- **Obuto (0-4 wiiki):** Starter (23% protein)\n" .
        "- **Enkulu (5-20 wiiki):** Grower (18% protein)\n" .
        "- **Layers:** Layer mash (16-17% protein)\n" .
        "- **Broilers:** Protein nnyingi, okukula mangu\n" .
        "- **Amazzi:** Amatonnyovu, buli kiseera\n\n" .
        "**Okuziyiza Obulwadhe:**\n" .
        "- Vaccination (Newcastle, Gumboro, etc.)\n" .
        "- Biosecurity\n" .
        "- Okugoba ensiriŋŋanyi buli kaseera\n" .
        "- Naazisa amazzi n'emmere buli lunaku\n\n" .
        "**Obulwadhe obwa bulijjo:**\n" .
        "- Newcastle Disease\n" .
        "- Coccidiosis\n" .
        "- Fowl pox\n" .
        "- Infectious Bronchitis\n\n" .
        "💡 **Vaccination** kikulu nnyo okuziyiza obulwadhe!",

    // ============================================================================
    // WEBALE (THANK YOU)
    // ============================================================================
    '/webale|mwebale|thank|nsonyiwa/i' =>
        "Webale nyo! 😊\n\n" .
        "Ndi wano buli kaseera okukuyamba mu lugendo lwo lw'obulimi. Tokuusa okumbuuza ebibuuzo ebirala!\n\n" .
        "**Jjukira:**\n" .
        "- Kebera ebirime byo buli kaseera\n" .
        "- Kozesa AIMS marketplace okutunda\n" .
        "- Teekawo alerts za miwendo\n" .
        "- Yingira mu bibiina by'abalimi\n\n" .
        "Kabisaana mu by'obulimi! 🌾🚜\n\n" .
        "*Happy farming!*",

    // ============================================================================
    // OKUYAMBA (HELP)
    // ============================================================================
    '/ditya.*okuyamba|help|capabilities|osobola.*okukola/i' =>
        "Nze omuyambi wo omugassi mu by'obulimi! Wano bye nkola:\n\n" .
        "🌱 **Obulwadhe bw'ebirime n'ebiwuka:**\n" .
        "- Okuzuula obulwadhe okuva ku bubonero\n" .
        "- Amagezi g'okujjanjaba (obuwangwa n'eddagala)\n" .
        "- Enkola z'okuziyiza\n\n" .
        "📅 **Obudde bw'okusimba:**\n" .
        "- Obudde obusingako obulungi mu Uganda\n" .
        "- Ensigo ezilungi\n" .
        "- Ekifo n'omuwendo gwa fertilizer\n\n" .
        "💰 **Emiwendo mu bbabali:**\n" .
        "- Emiwendo egiriwo kaakati\n" .
        "- Engeri z'okutunda\n" .
        "- Trend z'emiwendo\n\n" .
        "🌾 **Enkola ennungi:**\n" .
        "- Okuzuukusa ettaka\n" .
        "- Amagezi g'okukozesa fertilizer\n" .
        "- Okuddukanya amazzi\n" .
        "- Post-harvest handling\n\n" .
        "🐔 **Ebisolo:**\n" .
        "- Okulunda enkoko\n" .
        "- Okuddukanya amata\n" .
        "- Okufuga obulwadhe\n\n" .
        "🌤️ **Obudde:**\n" .
        "- Amagezi g'okusimba\n" .
        "- Okulima okw'amagezi\n\n" .
        "Mbuuza kyonna mu **Lungereza** oba **Lusoga**! Ndi wano! 🚜",
];