<?php
/**
 * ============================================================================
 * dashboard/widgets/farming-tips.php
 * Farming Tips Widget - Shows random agricultural tips
 * ============================================================================
 */
?>
<?php
// Fetch random farming tip from database or use predefined tips
$tips = [
    [
        'title' => 'Planting Season',
        'content' => 'Sugar cane yields the best results when planted at the beginning of the rainy season. Plan your planting for March-April or September-October!',
        'icon' => 'info-circle',
        'type' => 'info'
    ],
    [
        'title' => 'Product Photos',
        'content' => 'Posting clear photos of your products can increase sales by up to 40%! Make sure to take photos in good lighting.',
        'icon' => 'camera',
        'type' => 'success'
    ],
    [
        'title' => 'Market Prices',
        'content' => 'Check market prices regularly to ensure you\'re getting the best deals. Set up price alerts for your products!',
        'icon' => 'graph-up',
        'type' => 'warning'
    ],
    [
        'title' => 'Pest Control',
        'content' => 'Monitor your crops regularly for pests and diseases. Early detection and treatment can save your harvest!',
        'icon' => 'bug',
        'type' => 'danger'
    ],
    [
        'title' => 'Soil Health',
        'content' => 'Healthy soil means healthy crops. Consider testing your soil pH and adding organic matter to improve fertility.',
        'icon' => 'droplet',
        'type' => 'info'
    ]
];

// Select random tip
$randomTip = $tips[array_rand($tips)];
?>

<div class="card border-0 shadow-sm">
    <div class="card-header bg-white border-0 py-3">
        <h5 class="mb-0 fw-bold">
            <i class="bi bi-lightbulb text-warning me-2"></i>Farming Tip
        </h5>
    </div>
    <div class="card-body">
        <div class="alert alert-<?php echo $randomTip['type']; ?> mb-0 border-0">
            <h6 class="alert-heading fw-bold">
                <i class="bi bi-<?php echo $randomTip['icon']; ?> me-2"></i><?php echo $randomTip['title']; ?>
            </h6>
            <p class="small mb-2"><?php echo $randomTip['content']; ?></p>
            <a href="<?php echo APP_URL; ?>/learning/" class="btn btn-sm btn-<?php echo $randomTip['type']; ?>">
                <i class="bi bi-book me-1"></i>Learn More
            </a>
        </div>
    </div>
</div>