<?php
/**
 * ============================================================================
 * dashboard/widgets/notifications-widget.php
 * Notifications Widget - Shows recent notifications
 * ============================================================================
 */
?>
<?php
$userId = getUserId();
$database = new Database();
$db = $database->getConnection();

// Fetch recent notifications
$sql = "SELECT * FROM notifications 
        WHERE user_id = ? 
        ORDER BY created_at DESC 
        LIMIT 5";
$stmt = $db->prepare($sql);
$stmt->execute([$userId]);
$notifications = $stmt->fetchAll();

// Count unread
$sql = "SELECT COUNT(*) as unread FROM notifications WHERE user_id = ? AND is_read = 0";
$stmt = $db->prepare($sql);
$stmt->execute([$userId]);
$unreadCount = $stmt->fetch()['unread'] ?? 0;
?>

<div class="card border-0 shadow-sm">
    <div class="card-header bg-white border-0 py-3 d-flex justify-content-between align-items-center">
        <h5 class="mb-0 fw-bold">
            <i class="bi bi-bell text-warning me-2"></i>Notifications
            <?php if ($unreadCount > 0): ?>
                <span class="badge bg-danger rounded-pill"><?php echo $unreadCount; ?></span>
            <?php endif; ?>
        </h5>
        <a href="<?php echo APP_URL; ?>/notifications/" class="btn btn-sm btn-outline-primary">
            View All
        </a>
    </div>
    <div class="card-body p-0" style="max-height: 350px; overflow-y: auto;">
        <?php if (empty($notifications)): ?>
            <div class="text-center py-5 px-3">
                <i class="bi bi-bell-slash text-muted" style="font-size: 3rem;"></i>
                <p class="text-muted small mb-0 mt-2">No notifications</p>
            </div>
        <?php else: ?>
            <div class="list-group list-group-flush">
                <?php foreach ($notifications as $notif): ?>
                <a href="<?php echo $notif['link'] ?? '#'; ?>" 
                   class="list-group-item list-group-item-action <?php echo !$notif['is_read'] ? 'bg-light' : ''; ?>">
                    <div class="d-flex align-items-start">
                        <div class="flex-shrink-0 me-3">
                            <?php
                            $typeColors = [
                                'success' => 'success',
                                'danger' => 'danger',
                                'warning' => 'warning',
                                'info' => 'info'
                            ];
                            $color = $typeColors[$notif['type']] ?? 'primary';
                            ?>
                            <div class="bg-<?php echo $color; ?> bg-opacity-10 text-<?php echo $color; ?> rounded-circle p-2">
                                <i class="bi bi-<?php echo $notif['icon'] ?? 'bell'; ?>"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-start">
                                <h6 class="mb-1 small fw-semibold"><?php echo htmlspecialchars($notif['title']); ?></h6>
                                <?php if (!$notif['is_read']): ?>
                                    <span class="badge bg-primary rounded-pill">New</span>
                                <?php endif; ?>
                            </div>
                            <p class="mb-1 small text-muted"><?php echo htmlspecialchars($notif['message']); ?></p>
                            <small class="text-muted">
                                <i class="bi bi-clock me-1"></i><?php echo timeAgo($notif['created_at']); ?>
                            </small>
                        </div>
                    </div>
                </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
