<?php
/**
 * ============================================================================
 * dashboard/widgets/stats-card.php
 * Reusable Statistics Card Widget
 * ============================================================================
 */
?>
<?php
/**
 * Usage:
 * include 'widgets/stats-card.php';
 * renderStatCard('Total Products', 25, 'box-seam', 'primary', '5 active');
 */

function renderStatCard($title, $value, $icon, $color = 'primary', $subtitle = '') {
    ?>
    <div class="card stat-card shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <p class="text-muted mb-1 small"><?php echo $title; ?></p>
                    <h3 class="mb-0 fw-bold"><?php echo $value; ?></h3>
                    <?php if ($subtitle): ?>
                        <small class="text-<?php echo $color; ?>">
                            <i class="bi bi-check-circle"></i> <?php echo $subtitle; ?>
                        </small>
                    <?php endif; ?>
                </div>
                <div class="stat-icon bg-<?php echo $color; ?> bg-opacity-10 text-<?php echo $color; ?>">
                    <i class="bi bi-<?php echo $icon; ?>"></i>
                </div>
            </div>
        </div>
    </div>
    <?php
}
?>

<style>
.stat-card {
    border-radius: 15px;
    transition: all 0.3s ease;
    border: none;
    overflow: hidden;
    background: white;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.8rem;
}
</style>
