<?php
/**
 * ============================================================================
 * dashboard/widgets/weather-widget.php
 * Weather Widget - Displays current weather for Luuka District
 * ============================================================================
 */
?>
<?php
// Fetch weather data (you can integrate OpenWeatherMap API later)
$weather = [
    'temperature' => 28,
    'condition' => 'Partly Cloudy',
    'humidity' => 65,
    'wind_speed' => 12,
    'icon' => 'bi-cloud-sun',
    'location' => 'Luuka District'
];

// You can add API integration here
// Example: $weather = getWeatherData('Luuka');
?>

<div class="weather-widget shadow-sm">
    <div class="d-flex justify-content-between align-items-start mb-3">
        <div>
            <h5 class="mb-1 fw-bold">Weather Today</h5>
            <p class="mb-0 opacity-75 small"><?php echo $weather['location']; ?>, Uganda</p>
        </div>
        <i class="<?php echo $weather['icon']; ?>" style="font-size: 3rem;"></i>
    </div>
    
    <div class="d-flex align-items-end mb-3">
        <h1 class="display-3 mb-0 fw-bold"><?php echo $weather['temperature']; ?>°</h1>
        <span class="ms-2 mb-2 h6"><?php echo $weather['condition']; ?></span>
    </div>
    
    <div class="row small">
        <div class="col-6">
            <i class="bi bi-droplet me-1"></i> Humidity: <?php echo $weather['humidity']; ?>%
        </div>
        <div class="col-6">
            <i class="bi bi-wind me-1"></i> Wind: <?php echo $weather['wind_speed']; ?> km/h
        </div>
    </div>
    
    <div class="mt-3 pt-3 border-top border-white border-opacity-25">
        <small class="opacity-75">
            <i class="bi bi-info-circle me-1"></i>
            <?php
            // Weather-based farming advice
            if ($weather['temperature'] > 30) {
                echo "Hot weather - ensure adequate irrigation";
            } elseif ($weather['temperature'] < 20) {
                echo "Cool weather - good for planting";
            } else {
                echo "Good weather for farming activities";
            }
            ?>
        </small>
    </div>
</div>

<style>
.weather-widget {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 15px;
    padding: 25px;
}
</style>
