<?php
/**
 * Extension Sidebar Navigation
 * File: extension/includes/sidebar.php
 */

$currentPage = basename($_SERVER['PHP_SELF']);

// Get pending counts
try {
    $sql = "SELECT 
                (SELECT COUNT(*) FROM extension_reports WHERE status = 'draft' AND submitted_by = ?) as my_draft_reports,
                (SELECT COUNT(*) FROM extension_reports er 
                 INNER JOIN extension_assignments ea ON er.assignment_id = ea.id 
                 WHERE er.status = 'submitted') as pending_reviews,
                (SELECT COUNT(*) FROM extension_services WHERE officer_id = ? AND status = 'scheduled' AND scheduled_date >= CURDATE()) as upcoming_services";
    $stmt = $db->prepare($sql);
    $stmt->execute([$currentUserId, $currentUserId]);
    $counts = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $counts = ['my_draft_reports' => 0, 'pending_reviews' => 0, 'upcoming_services' => 0];
}
?>

<!-- Extension Sidebar -->
<div class="extension-sidebar">
    <!-- Dashboard -->
    <div class="nav-section-title">Main</div>
    <a href="<?php echo APP_URL; ?>/extension/index.php" class="nav-link <?php echo $currentPage === 'index.php' ? 'active' : ''; ?>">
        <i class="bi bi-speedometer2"></i>
        <span>Dashboard</span>
    </a>

    <!-- Services & Activities -->
    <div class="nav-section-title">Services</div>
    
    <a href="<?php echo APP_URL; ?>/extension/services.php" class="nav-link <?php echo $currentPage === 'services.php' ? 'active' : ''; ?>">
        <i class="bi bi-calendar-check"></i>
        <span>My Services</span>
        <?php if ($counts['upcoming_services'] > 0): ?>
        <span class="badge bg-warning"><?php echo $counts['upcoming_services']; ?></span>
        <?php endif; ?>
    </a>
    
    <a href="<?php echo APP_URL; ?>/extension/schedule-service.php" class="nav-link <?php echo $currentPage === 'schedule-service.php' ? 'active' : ''; ?>">
        <i class="bi bi-calendar-plus"></i>
        <span>Schedule Service</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/extension/activities.php" class="nav-link <?php echo $currentPage === 'activities.php' ? 'active' : ''; ?>">
        <i class="bi bi-activity"></i>
        <span>Activity Log</span>
    </a>

    <!-- Farmers & Coverage -->
    <div class="nav-section-title">Coverage Area</div>
    
    <a href="<?php echo APP_URL; ?>/extension/farmers.php" class="nav-link <?php echo $currentPage === 'farmers.php' ? 'active' : ''; ?>">
        <i class="bi bi-people"></i>
        <span>Farmers</span>
    </a>
    
    <?php if ($extensionSystem->hasPermission('manage_region') || 
              $extensionSystem->hasPermission('manage_district') || 
              $extensionSystem->hasPermission('manage_subcounty') || 
              $extensionSystem->hasPermission('manage_parish')): ?>
    <a href="<?php echo APP_URL; ?>/extension/subordinates.php" class="nav-link <?php echo $currentPage === 'subordinates.php' ? 'active' : ''; ?>">
        <i class="bi bi-diagram-3"></i>
        <span>Subordinates</span>
    </a>
    <?php endif; ?>

    <!-- Resources & Knowledge -->
    <div class="nav-section-title">Resources</div>
    
    <a href="<?php echo APP_URL; ?>/extension/resources.php" class="nav-link <?php echo $currentPage === 'resources.php' ? 'active' : ''; ?>">
        <i class="bi bi-book"></i>
        <span>Resources</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/extension/tips.php" class="nav-link <?php echo $currentPage === 'tips.php' ? 'active' : ''; ?>">
        <i class="bi bi-lightbulb"></i>
        <span>Agricultural Tips</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/extension/diseases.php" class="nav-link <?php echo $currentPage === 'diseases.php' ? 'active' : ''; ?>">
        <i class="bi bi-bug"></i>
        <span>Crop Diseases</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/extension/prices.php" class="nav-link <?php echo $currentPage === 'prices.php' ? 'active' : ''; ?>">
        <i class="bi bi-currency-dollar"></i>
        <span>Market Prices</span>
    </a>

    <!-- Reports & Analytics -->
    <div class="nav-section-title">Reports</div>
    
    <a href="<?php echo APP_URL; ?>/extension/reports.php" class="nav-link <?php echo $currentPage === 'reports.php' ? 'active' : ''; ?>">
        <i class="bi bi-file-earmark-text"></i>
        <span>My Reports</span>
        <?php if ($counts['my_draft_reports'] > 0): ?>
        <span class="badge bg-info"><?php echo $counts['my_draft_reports']; ?></span>
        <?php endif; ?>
    </a>
    
    <?php if ($extensionSystem->hasPermission('view_reports') || $extensionSystem->hasPermission('approve_reports')): ?>
    <a href="<?php echo APP_URL; ?>/extension/review-reports.php" class="nav-link <?php echo $currentPage === 'review-reports.php' ? 'active' : ''; ?>">
        <i class="bi bi-clipboard-check"></i>
        <span>Review Reports</span>
        <?php if ($counts['pending_reviews'] > 0): ?>
        <span class="badge bg-warning"><?php echo $counts['pending_reviews']; ?></span>
        <?php endif; ?>
    </a>
    <?php endif; ?>
    
    <?php if ($extensionSystem->hasPermission('view_all_reports') || $extensionSystem->hasPermission('view_reports')): ?>
    <a href="<?php echo APP_URL; ?>/extension/analytics.php" class="nav-link <?php echo $currentPage === 'analytics.php' ? 'active' : ''; ?>">
        <i class="bi bi-graph-up"></i>
        <span>Analytics</span>
    </a>
    <?php endif; ?>

    <!-- Management (For Higher Levels) -->
    <?php if ($extensionSystem->hasPermission('assign_regional') || 
              $extensionSystem->hasPermission('assign_district') || 
              $extensionSystem->hasPermission('assign_subcounty') || 
              $extensionSystem->hasPermission('assign_parish')): ?>
    <div class="nav-section-title">Management</div>
    
    <a href="<?php echo APP_URL; ?>/extension/assignments.php" class="nav-link <?php echo $currentPage === 'assignments.php' ? 'active' : ''; ?>">
        <i class="bi bi-person-badge"></i>
        <span>Manage Assignments</span>
    </a>
    
    <a href="<?php echo APP_URL; ?>/extension/organizations.php" class="nav-link <?php echo $currentPage === 'organizations.php' ? 'active' : ''; ?>">
        <i class="bi bi-building"></i>
        <span>Organizations</span>
    </a>
    <?php endif; ?>

    <!-- Help & Documentation -->
    <div class="nav-section-title">Help</div>
    <a href="<?php echo APP_URL; ?>/extension/help.php" class="nav-link <?php echo $currentPage === 'help.php' ? 'active' : ''; ?>">
        <i class="bi bi-question-circle"></i>
        <span>Help & Guidelines</span>
    </a>
</div>