<?php
/**
 * ============================================================================
 * extension/index.php - Extension Portal Router
 * Routes extension officers based on assignment status
 * ============================================================================
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

// Check authentication
if (!isLoggedIn()) {
    redirectTo('/auth/login.php');
}

// Verify extension officer
if (getUserType() !== 'extension_officer') {
    redirectTo('/dashboard/');
}

// Load Extension System
require_once __DIR__ . '/includes/ExtensionSystem.php';

$database = new Database();
$db = $database->getConnection();
$extensionSystem = new ExtensionSystem($db, getUserId());

// Check if officer has assignment
if ($extensionSystem->hasAssignment()) {
    // Has hierarchical assignment - use new dashboard
    require_once __DIR__ . '/dashboard.php';
} else {
    // No assignment yet - use legacy dashboard
    require_once __DIR__ . '/../dashboard/extension-dashboard.php';
}
?>