<?php
/**
 * friends/ajax/unfriend.php
 * Unfriend User AJAX Handler
 */

define('AIMS_ACCESS', true);
require_once __DIR__ . '/../../config/config.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Please log in']);
    exit;
}

$userId = getUserId();
$friendId = filter_input(INPUT_POST, 'friend_id', FILTER_VALIDATE_INT);

if (!$friendId) {
    echo json_encode(['success' => false, 'message' => 'Invalid friend ID']);
    exit;
}

// Get database connection
$database = new Database();
$db = $database->getConnection();
$friendship = new \App\Friendship($db);

$result = $friendship->removeFriend($userId, $friendId);

echo json_encode($result);
?>