<?php
/**
 * ============================================================================
 * groups/test.php - Simple Test Page to Verify Routing
 * ============================================================================
 * Visit: http://localhost/aims/groups/test
 * This will help diagnose the routing issue
 */

echo "<h1>✅ Groups Directory is Accessible!</h1>";
echo "<p>Current URL: " . $_SERVER['REQUEST_URI'] . "</p>";
echo "<p>Script Name: " . $_SERVER['SCRIPT_NAME'] . "</p>";
echo "<p>PHP Self: " . $_SERVER['PHP_SELF'] . "</p>";
echo "<hr>";
echo "<h3>If you can see this, your groups directory works!</h3>";
echo "<p>The issue is specifically with <code>index.php</code></p>";

// Test APP_URL constant
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../config/config.php';

echo "<h3>Configuration Test:</h3>";
echo "<p>APP_URL: <strong>" . APP_URL . "</strong></p>";

echo "<h3>Links Test:</h3>";
echo "<ul>";
echo "<li><a href='" . APP_URL . "/groups/'>Groups Index (Testing)</a></li>";
echo "<li><a href='" . APP_URL . "/groups/index'>Groups Index (No extension)</a></li>";
echo "<li><a href='" . APP_URL . "/groups/index.php'>Groups Index (With .php)</a></li>";
echo "<li><a href='" . APP_URL . "/groups/create'>Create Group</a></li>";
echo "<li><a href='" . APP_URL . "/chat/'>Back to Chat</a></li>";
echo "</ul>";

?>