<?php
/**
 * AIMS Helper Functions
 * File: includes/helpers.php
 * Student: Musumba Jonathan (21/BCS/010/UMC)
 */

if (!function_exists('setFlashMessage')) {
    /**
     * Set a flash message in session
     */
    function setFlashMessage($message, $type = 'success') {
        if (!isset($_SESSION)) {
            session_start();
        }
        $_SESSION['flash_message'] = [
            'message' => $message,
            'type' => $type
        ];
    }
}

if (!function_exists('getFlashMessage')) {
    /**
     * Get and clear flash message
     */
    function getFlashMessage() {
        if (!isset($_SESSION)) {
            session_start();
        }
        
        if (isset($_SESSION['flash_message'])) {
            $flash = $_SESSION['flash_message'];
            unset($_SESSION['flash_message']);
            return $flash;
        }
        
        return null;
    }
}

if (!function_exists('hasFlashMessage')) {
    /**
     * Check if flash message exists
     */
    function hasFlashMessage() {
        if (!isset($_SESSION)) {
            session_start();
        }
        return isset($_SESSION['flash_message']);
    }
}

if (!function_exists('displayFlashMessage')) {
    /**
     * Display flash message HTML
     */
    function displayFlashMessage() {
        $flash = getFlashMessage();
        if ($flash) {
            $alertClass = $flash['type'] === 'success' ? 'alert-success' : 
                         ($flash['type'] === 'error' ? 'alert-danger' : 'alert-info');
            
            echo '<div class="alert ' . $alertClass . ' alert-dismissible fade show" role="alert">';
            echo htmlspecialchars($flash['message']);
            echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
            echo '</div>';
        }
    }
}