<?php
/**
 * ============================================================================
 * AIMS Profile Cover Photo Upload Handler
 * File: profile/ajax/upload-cover-photo.php
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../classes/Profile.php';

header('Content-Type: application/json');

requireLogin();

try {
    if (!isset($_FILES['profile_picture'])) {
        echo json_encode(['success' => false, 'message' => 'No file uploaded']);
        exit;
    }
    
    $database = \App\Database::getInstance();
    $db = $database->getConnection();
    $profile = new \App\Profile($db);
    
    $userId = getUserId();
    $result = $profile->uploadProfilePicture($userId, $_FILES['profile_picture']);
    
    echo json_encode($result);
    
} catch (Exception $e) {
    error_log("Profile picture upload error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Upload failed: ' . $e->getMessage()]);
}
?>