<?php
/**
 * Test Authentication Setup
 * Place this file in your root directory and access it via browser
 * File: test-auth.php
 */

define('AIMS_ACCESS', true);
require_once 'config/config.php';

// Test database connection
try {
    $database = new Database();
    $db = $database->getConnection();
    echo "✓ Database connection successful<br>";
} catch (Exception $e) {
    die("✗ Database connection failed: " . $e->getMessage());
}

// Test if admin user exists
try {
    $sql = "SELECT * FROM users WHERE phone_number = '+256787842061'";
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($admin) {
        echo "✓ Admin user found<br>";
        echo "  - Phone: " . $admin['phone_number'] . "<br>";
        echo "  - Name: " . $admin['full_name'] . "<br>";
        echo "  - Type: " . $admin['user_type'] . "<br>";
        echo "  - Verified: " . ($admin['is_verified'] ? 'Yes' : 'No') . "<br>";
        echo "  - Active: " . ($admin['is_active'] ? 'Yes' : 'No') . "<br>";
        echo "  - Approval: " . $admin['approval_status'] . "<br>";
    } else {
        echo "✗ Admin user not found<br>";
        echo "<pre>";
        echo "Run this SQL to create admin user:\n\n";
        echo "INSERT INTO users (phone_number, password_hash, full_name, email, user_type, is_verified, approval_status, is_active) VALUES\n";
        echo "('+256787842061', '\$2y\$12\$LQv3c1yqBWVHxkd0LHAkCOYz6TtxMQJqhN8/LewY5GyB0.jRpWQXO', 'Musumba Jonathan', 'jmprossy@gmail.com', 'admin', 1, 'approved', 1);\n";
        echo "</pre>";
    }
} catch (Exception $e) {
    echo "✗ Error checking admin user: " . $e->getMessage() . "<br>";
}

// Test password verification
try {
    $testPassword = 'admin123';
    $hash = '$2y$12$LQv3c1yqBWVHxkd0LHAkCOYz6TtxMQJqhN8/LewY5GyB0.jRpWQXO';
    
    if (password_verify($testPassword, $hash)) {
        echo "✓ Password verification working<br>";
    } else {
        echo "✗ Password verification failed<br>";
    }
} catch (Exception $e) {
    echo "✗ Password test error: " . $e->getMessage() . "<br>";
}

// Test helper functions
echo "<br><strong>Testing Helper Functions:</strong><br>";

// Test validatePhone
if (function_exists('validatePhone')) {
    $testPhone = validatePhone('+256787842061');
    if ($testPhone === '+256787842061') {
        echo "✓ validatePhone() working<br>";
    } else {
        echo "✗ validatePhone() not working correctly<br>";
    }
} else {
    echo "✗ validatePhone() function not found<br>";
}

// Test sanitize
if (function_exists('sanitize')) {
    $test = sanitize('<script>alert("test")</script>');
    echo "✓ sanitize() working<br>";
} else {
    echo "✗ sanitize() function not found<br>";
}

// Test jsonSuccess and jsonError
if (function_exists('jsonSuccess') && function_exists('jsonError')) {
    echo "✓ JSON helper functions found<br>";
} else {
    echo "✗ JSON helper functions not found<br>";
}

// Test User class
try {
    require_once 'classes/User.php';
    $user = new User($db);
    echo "✓ User class loaded successfully<br>";
} catch (Exception $e) {
    echo "✗ User class error: " . $e->getMessage() . "<br>";
}

// Test login API endpoint
echo "<br><strong>Testing API Endpoint:</strong><br>";
if (file_exists('api/auth.php')) {
    echo "✓ api/auth.php exists<br>";
} else {
    echo "✗ api/auth.php not found<br>";
}

// Test APP_URL constant
echo "<br><strong>Configuration:</strong><br>";
echo "APP_URL: " . APP_URL . "<br>";
echo "APP_ENV: " . APP_ENV . "<br>";
echo "APP_DEBUG: " . (APP_DEBUG ? 'true' : 'false') . "<br>";

echo "<br><strong>Test Admin Login:</strong><br>";
echo "Phone: +256787842061<br>";
echo "Password: admin123<br>";
echo "<a href='auth/login.php' style='display:inline-block; margin-top:10px; padding:10px 20px; background:#059669; color:white; text-decoration:none; border-radius:5px;'>Go to Login Page</a>";
?>