<?php
/**
 * ============================================================================
 * chat/ajax/get-messages.php - Get New Messages Endpoint
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../../config/config.php';

header('Content-Type: application/json');
requireLogin();

try {
    $userId = getUserId();
    $chatId = intval($_GET['chat_id'] ?? 0);
    $afterId = intval($_GET['after_id'] ?? 0);
    
    if (!$chatId) {
        echo json_encode([
            'success' => false,
            'message' => 'Chat ID is required'
        ]);
        exit;
    }
    
    $database = new Database();
    $db = $database->getConnection();
    
    // Check if user is member
    $sql = "SELECT 1 FROM chat_members WHERE chat_id = ? AND user_id = ?";
    $stmt = $db->prepare($sql);
    $stmt->execute([$chatId, $userId]);
    
    if (!$stmt->fetch()) {
        echo json_encode([
            'success' => false,
            'message' => 'Access denied'
        ]);
        exit;
    }
    
    // Get new messages
    $sql = "SELECT m.*, 
            u.full_name as sender_name, 
            u.profile_picture as sender_avatar
            FROM messages m
            JOIN users u ON m.sender_id = u.id
            WHERE m.chat_id = ? AND m.id > ?
            ORDER BY m.created_at ASC";
    
    $stmt = $db->prepare($sql);
    $stmt->execute([$chatId, $afterId]);
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'messages' => $messages
    ]);
    
} catch (Exception $e) {
    error_log('Get messages error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Failed to get messages: ' . $e->getMessage()
    ]);
}
?>