<?php
/**
 * ============================================================================
 * chat/ajax/send-message.php - Send Message Endpoint
 * ============================================================================
 */
define('AIMS_ACCESS', true);
require_once __DIR__ . '/../../config/config.php';

header('Content-Type: application/json');
requireLogin();

try {
    $userId = getUserId();
    $chatId = intval($_POST['chat_id'] ?? 0);
    $content = trim($_POST['content'] ?? '');
    $messageType = $_POST['message_type'] ?? 'text';
    $encrypt = filter_var($_POST['encrypt'] ?? false, FILTER_VALIDATE_BOOLEAN);
    
    if (!$chatId || !$content) {
        echo json_encode([
            'success' => false,
            'message' => 'Chat ID and content are required'
        ]);
        exit;
    }
    
    $database = new Database();
    $db = $database->getConnection();
    $messageClass = new \App\Message($db);
    
    // Send message
    $result = $messageClass->send($chatId, $userId, [
        'content' => $content,
        'message_type' => $messageType,
        'media_url' => $_POST['media_url'] ?? null
    ], $encrypt);
    
    if ($result['success']) {
        // Get the full message details
        $sql = "SELECT m.*, u.full_name as sender_name, u.profile_picture as sender_avatar
                FROM messages m
                JOIN users u ON m.sender_id = u.id
                WHERE m.id = ?";
        $stmt = $db->prepare($sql);
        $stmt->execute([$result['message_id']]);
        $message = $stmt->fetch(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => $message
        ]);
    } else {
        echo json_encode($result);
    }
    
} catch (Exception $e) {
    error_log('Send message error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Failed to send message: ' . $e->getMessage()
    ]);
}
?>